// Cmd.h: interface for the CCmd class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_CMD_H__29E9CF5F_BBB1_42A5_B84B_59B03FE5D46A__INCLUDED_)
#define AFX_CMD_H__29E9CF5F_BBB1_42A5_B84B_59B03FE5D46A__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#ifndef		CMD_H
#define		CMD_H

#include <afxcoll.h>
#include "CmdParam.h"
#include "ShTarget.h"

/////////////////////////////////////////////////////////////////////////////
#ifdef COMMON_EXPORTS
	#define COMMON_API __declspec(dllexport)
#else
	#define COMMON_API __declspec(dllimport)
#endif
/////////////////////////////////////////////////////////////////////////////
#pragma warning (disable : 4251)
#pragma warning (disable : 4275)
/////////////////////////////////////////////////////////////////////////////
#define SET_TYPE			1
#define GET_TYPE			2
#define STATEMENT_TYPE		4
#define LIST_TYPE			8
#define NB_TYPES			4

#define SERVICE_CFG			1
#define SERVICE_DATA		2
#define SERVICE_GPRS		3
#define SERVICE_NWK			4
#define SERVICE_PHB			5
#define SERVICE_POW			6
#define SERVICE_SMS			7
#define SERVICE_SND			8
#define SERVICE_SPC			9
#define SERVICE_STY			10
#define SERVICE_SIM			11
//////////////////////////////////////////////////////////////////////////////////
struct StructAT 
{
	char* prefix;
	char* cmdName;
	int cmdID;
	int serviceID;
	char* serviceName;
	UInt8 supportedType;
	bool cpin;	
	bool creg;
	int cfun;
	void* svcP; // pointer to the service
	CList<StructParam,StructParam&>* mStructParamList;
	int response; // if response!=-1, interpretor will return response
	int delay;
};
//////////////////////////////////////////////////////////////////////////////////

class COMMON_API CCmd : public CObject  
{
private:
	CString mName;
	int		mCmdID;
	bool	mCPin;
	bool	mSemiColon;
	bool	mCReg;
	int		mCFun;	
	int		mServiceID;
	void*	mSvcP;
	CObArray *tabParam;	
	CString mPrefix;
	int		mSupportedType;
	int		mCurrentType;
	UInt8	mChannel;
	Bool	mIsLast;
	Bool	mDataMode;

	/*Dll Generator specific*/
	CString mServiceName; // service class full name that the command belong to
	CString mImplementation; // code implementation fill by the user
	
public:	
	CCmd(StructAT iLine);
	CCmd(CCmd* iCmdP);
	CCmd();
	virtual ~CCmd();
	void	AddParam(CString iName, int iType, int iGroup);
	void	AddParam(CCmdParam* iParamP);	
	void	ResetParam();
	CString ToString(CString iPrefix);
	CString RangeList();

	/*******************************/
	//Accessors
	/*******************************/
	//GET
	int			GetCFun();	
	int			GetCmdID();
	int			GetServiceID();
	void*		GetSvcP();	
	CCmdParam*	GetParam(CString iParamName);
	CCmdParam*	GetParam(int iParamIndex);
	CString		GetName();
	CObArray*	GetParam();
	CString		GetImplementation();
	CString		GetServiceName();
	CString		GetPrefix();	
	UInt8		GetCurrentType();
	UInt8		GetChannel();
	int			GetUniqueCmdID();	
	virtual UInt8 GetSupportedType();

	//SET
	void SetName(CString iName);
	void SetCPin(bool iCPin);
	void SetCFun(int iCFun);
	void SetCReg(bool iCReg);
	void SetCmdID(int iCmdID);
	void SetServiceID(int iServiceID);
	void SetSvcP(void* iSvcP);	
	void SetImplementation(CString iImplementation);
	void SetSemiColon(bool iSemiColon);
	void SetPrefix(CString iPrefix);
	void SetSupportedType(UInt8 iTypes); //use like this SetSupportedType(SET_TYPE | GET_TYPE ...)
	void SetCurrentType(UInt8 iType);
	void SetServiceName(CString iServiceName);
	void SetChannel(UInt8 iChannel);
	void SetIsLast(Bool iIsLast);
	void SetDataMode(Bool iDataMode);
	
	//IS	
	bool IsSet();
	bool IsGet();
	bool IsList();
	bool IsStatement();
	bool IsCPin();
	bool IsCReg();
	bool IsSemiColon();
	Bool IsTypeSupported(UInt8 iType);
	Bool IsLast();
	Bool IsDataMode();

	/***************************/
	//Shortcuts to access parameters
	/***************************/
	int		GetInt(UInt16 iParamIndex);
	double	GetDouble(UInt16 iParamIndex);
	CString GetString(UInt16 iParamIndex);
	Bool	GetFlag(UInt16 iParamIndex);
	Bool	IsParamLeft(UInt16 iParamIndex);
};
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
#endif
#endif // !defined(AFX_CMD_H__29E9CF5F_BBB1_42A5_B84B_59B03FE5D46A__INCLUDED_)
